/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.fabric.platform.network;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mod.chiselsandbits.fabric.platform.network.FabricNetworkChannelClientMessageProcessor;
import mod.chiselsandbits.fabric.platform.network.FabricNetworkChannelServerMessageProcessor;
import mod.chiselsandbits.platforms.core.dist.Dist;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import mod.chiselsandbits.platforms.core.network.INetworkChannel;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public final class FabricNetworkChannel
implements INetworkChannel {
    private final class_2960 name;
    private final Map<Integer, NetworkMessageSpecification<?>> messageSpecifications = Maps.newHashMap();

    public FabricNetworkChannel(class_2960 name) {
        this.name = name;
        FabricNetworkChannelServerMessageProcessor.registerServerChannel(name, this.messageSpecifications::get);
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> FabricNetworkChannelClientMessageProcessor.registerClientChannel(name, this.messageSpecifications::get));
    }

    public <T> void handleMessageSerialization(T message, class_2540 friendlyByteBuf) {
        NetworkMessageSpecification<?> spec = this.getSpec(message.getClass());
        friendlyByteBuf.method_10804(spec.id);
        spec.serializer.accept(message, friendlyByteBuf);
    }

    @Override
    public <T> void register(int id, Class<T> msgClass, BiConsumer<T, class_2540> serializer, Function<class_2540, T> creator, INetworkChannel.MessageExecutionHandler<T> executionHandler) {
        NetworkMessageSpecification<T> spec = new NetworkMessageSpecification<T>(id, msgClass, serializer, creator, executionHandler);
        this.messageSpecifications.put(spec.id, spec);
    }

    @Override
    public void sendToServer(Object msg) {
        DistExecutor.runWhenOn(Dist.CLIENT, () -> () -> {
            if (class_310.method_1551().method_1562() == null) {
                return;
            }
            class_2540 buf = PacketByteBufs.create();
            this.handleMessageSerialization(msg, buf);
            ClientPlayNetworking.send((class_2960)this.name, (class_2540)buf);
        });
    }

    @Override
    public void sendToPlayer(Object msg, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        this.handleMessageSerialization(msg, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.name, (class_2540)buf);
    }

    private <T> NetworkMessageSpecification<T> getSpec(Class<T> networkMessageClass) {
        return this.messageSpecifications.values().stream().filter(spec -> spec.msgClass.equals(networkMessageClass)).findFirst().orElseThrow();
    }

    static final class NetworkMessageSpecification<T> {
        private final int id;
        private final Class<T> msgClass;
        private final BiConsumer<T, class_2540> serializer;
        private final Function<class_2540, T> creator;
        private final INetworkChannel.MessageExecutionHandler<T> executionHandler;

        private NetworkMessageSpecification(int id, Class<T> msgClass, BiConsumer<T, class_2540> serializer, Function<class_2540, T> creator, INetworkChannel.MessageExecutionHandler<T> executionHandler) {
            this.id = id;
            this.msgClass = msgClass;
            this.serializer = serializer;
            this.creator = creator;
            this.executionHandler = executionHandler;
        }

        public int getId() {
            return this.id;
        }

        public Class<T> getMsgClass() {
            return this.msgClass;
        }

        public BiConsumer<T, class_2540> getSerializer() {
            return this.serializer;
        }

        public Function<class_2540, T> getCreator() {
            return this.creator;
        }

        public INetworkChannel.MessageExecutionHandler<T> getExecutionHandler() {
            return this.executionHandler;
        }
    }
}

